/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.JICP;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class JICPCompressor3 {
    private static final int WORD_MAGIC = 200;
    private static final int RLE_MAGIC = 201;
    private static final int MAX_WORDS = 254;
    private static final int RLE_FLUSH = 256;
    private int rleOldValue = 256;
    private int rleOccurrence = 0;
    private int count = 0;
    private byte[] ba;

    private static boolean isSep(int value) {
        return !(value >= 65 && value <= 90 || value >= 97 && value <= 122 || value >= 48 && value <= 57 || value == 45 || value == 95);
    }

    private void rleWrite(ByteArrayOutputStream baos, int value) {
        if (this.rleOldValue == 256) {
            this.rleOldValue = value;
            this.rleOccurrence = 1;
            return;
        }
        if (value != this.rleOldValue || this.rleOccurrence == 255) {
            if (this.rleOldValue == 201 || this.rleOccurrence > 2) {
                baos.write(201);
                baos.write(this.rleOccurrence);
                if (this.rleOccurrence > 2) {
                    baos.write(this.rleOldValue);
                }
            } else {
                int i = 0;
                while (i < this.rleOccurrence) {
                    baos.write(this.rleOldValue);
                    ++i;
                }
            }
            this.rleOccurrence = 0;
        }
        ++this.rleOccurrence;
        this.rleOldValue = value;
    }

    private int rleRead(ByteArrayInputStream bais) {
        if (this.rleOccurrence == 0) {
            this.rleOldValue = bais.read();
            if (this.rleOldValue == 201) {
                this.rleOccurrence = bais.read();
                if (this.rleOccurrence > 2) {
                    this.rleOldValue = bais.read();
                }
            } else {
                this.rleOccurrence = 1;
            }
        }
        --this.rleOccurrence;
        return this.rleOldValue;
    }

    private int getValue(int index) {
        return index >= this.ba.length || index < 0 ? 256 : (char)this.ba[index] & 0xFF;
    }

    private void setValue(int index, int value) {
        if (index >= this.ba.length) {
            byte[] newba = new byte[index * 5 / 4];
            System.arraycopy(this.ba, 0, newba, 0, this.ba.length);
            this.ba = newba;
        }
        this.ba[index] = (byte)value;
    }

    public static byte[] compress(byte[] ba) {
        return new JICPCompressor3().compressHelper(ba);
    }

    private byte[] compressHelper(byte[] uba) {
        int[] wordIndexes = new int[254];
        int wordIndex = 0;
        int lastWordIndex = 0;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.ba = uba;
        int i = 0;
        while (i < this.ba.length) {
            int lastValue = this.getValue(i - 1);
            int value = this.getValue(i);
            if (JICPCompressor3.isSep(lastValue) && !JICPCompressor3.isSep(value)) {
                int maxJ = 0;
                int maxJIndex = -1;
                int wi = 0;
                while (wi < lastWordIndex) {
                    int ch2;
                    int ch1;
                    int existingWordIndex = wordIndexes[wi];
                    int j = 0;
                    while ((ch1 = this.getValue(existingWordIndex + j)) == (ch2 = this.getValue(i + j)) && ++j != 255) {
                    }
                    if (j > maxJ) {
                        maxJ = j;
                        maxJIndex = wi;
                    }
                    ++wi;
                }
                if (maxJ >= 4) {
                    this.rleWrite(baos, 200);
                    this.rleWrite(baos, maxJIndex);
                    this.rleWrite(baos, maxJ);
                    i += maxJ;
                    continue;
                }
                if (wordIndex == 254) {
                    wordIndex = 0;
                }
                wordIndexes[wordIndex++] = i;
                if (wordIndex > lastWordIndex) {
                    lastWordIndex = wordIndex;
                }
                this.rleWrite(baos, value);
                ++i;
                continue;
            }
            this.rleWrite(baos, value);
            if (value == 200) {
                this.rleWrite(baos, 255);
            }
            ++i;
        }
        this.rleWrite(baos, 256);
        byte[] result = baos.toByteArray();
        return result;
    }

    public static byte[] decompress(byte[] cba) {
        return new JICPCompressor3().decompressHelper(cba);
    }

    /*
     * WARNING - void declaration
     */
    private byte[] decompressHelper(byte[] cba) {
        int ch;
        int[] wordIndexes = new int[254];
        int wordIndex = 0;
        int currentIndex = 0;
        ByteArrayInputStream bais = new ByteArrayInputStream(cba);
        int oldCh = -1;
        this.ba = new byte[cba.length * 3 / 2];
        while ((ch = this.rleRead(bais)) != -1) {
            void var6_7;
            if (var6_7 == 200) {
                int wi = this.rleRead(bais);
                if (wi == 255) {
                    this.setValue(currentIndex++, 200);
                    continue;
                }
                int refWordIndex = wordIndexes[wi];
                int len = this.rleRead(bais);
                int i = 0;
                while (i < len) {
                    this.setValue(currentIndex++, this.ba[refWordIndex++]);
                    ++i;
                }
                continue;
            }
            if (JICPCompressor3.isSep(this.getValue(currentIndex - 1)) && !JICPCompressor3.isSep((int)var6_7)) {
                if (wordIndex == 254) {
                    wordIndex = 0;
                }
                wordIndexes[wordIndex++] = currentIndex;
            }
            this.setValue(currentIndex++, (int)var6_7);
        }
        byte[] newba = new byte[currentIndex];
        System.arraycopy(this.ba, 0, newba, 0, currentIndex);
        return newba;
    }
}

